#!/bin/bash
set -euo pipefail

HOST="remoto.swo.es"
KEY="VD6V9liepeGpm005qaXdhjaQXrhq81SzDJsIJ83Wt9I="
CFG="host=${HOST},key=${KEY}"

echo "== Soporte Saraworld (macOS) =="
echo "Este asistente instalará RustDesk y lo dejará configurado contra ${HOST}."
echo

ARCH="$(uname -m)"
if [[ "$ARCH" == "arm64" || "$ARCH" == "aarch64" ]]; then
  DMG_URL="https://${HOST}/downloads/Soporte-Saraworld-macOS-AppleSilicon.dmg"
  echo "Detectado Apple Silicon (${ARCH})"
else
  DMG_URL="https://${HOST}/downloads/Soporte-Saraworld-macOS-Intel.dmg"
  echo "Detectado Intel (${ARCH})"
fi

TMP_DMG="/tmp/Soporte-Saraworld.dmg"
echo "Descargando DMG..."
curl -fL "$DMG_URL" -o "$TMP_DMG"

echo "Montando DMG..."
ATTACH_OUT="$(hdiutil attach "$TMP_DMG" -nobrowse)"
VOL="$(echo "$ATTACH_OUT" | awk -F'\t' 'NF{print $NF}' | tail -n 1)"

if [[ -z "$VOL" || ! -d "$VOL" ]]; then
  echo "ERROR: no se pudo determinar el volumen montado."
  exit 1
fi

APP_SRC="${VOL}/RustDesk.app"
if [[ ! -d "$APP_SRC" ]]; then
  echo "ERROR: no se encontró RustDesk.app en el DMG."
  hdiutil detach "$VOL" >/dev/null 2>&1 || true
  exit 1
fi

echo "Instalando en /Applications (pedirá contraseña de administrador)..."
sudo mkdir -p /Applications
sudo ditto -rsrc "$APP_SRC" /Applications/RustDesk.app

echo "Desmontando DMG..."
hdiutil detach "$VOL" >/dev/null 2>&1 || true

echo "Quitando cuarentena (por si Gatekeeper molesta)..."
sudo xattr -dr com.apple.quarantine /Applications/RustDesk.app >/dev/null 2>&1 || true

echo "Aplicando configuración (server + key) y abriendo RustDesk..."
open -a /Applications/RustDesk.app --args --config "$CFG" || true

echo
echo "LISTO."
echo "Si macOS pide permisos (Grabación de pantalla / Accesibilidad), concédeselos para que funcione el control remoto."
echo
